/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TintWithoutLevelOverrider
implements BlockAndTintGetter {
    @Nullable
    private final Biome biome;

    public TintWithoutLevelOverrider(BiomeWrapper biomeWrapper, IClientLevelWrapper clientLevelWrapper) {
        BiomeWrapper plainsBiomeWrapper;
        Biome unwrappedBiome = null;
        if (biomeWrapper.biome != null) {
            unwrappedBiome = TintWithoutLevelOverrider.unwrap(biomeWrapper.biome);
        }
        if (unwrappedBiome == null && (plainsBiomeWrapper = (BiomeWrapper)clientLevelWrapper.getPlainsBiomeWrapper()) != null) {
            unwrappedBiome = TintWithoutLevelOverrider.unwrap(plainsBiomeWrapper.biome);
        }
        this.biome = unwrappedBiome;
    }

    public int getBlockTint(@NotNull BlockPos blockPos, @NotNull ColorResolver colorResolver) {
        if (this.biome != null) {
            return colorResolver.getColor(this.biome, (double)blockPos.getX(), (double)blockPos.getZ());
        }
        return ColorUtil.CYAN;
    }

    private static Biome unwrap(Holder<Biome> biome) {
        return (Biome)biome.value();
    }

    public float getShade(@NotNull Direction direction, boolean shade) {
        throw new UnsupportedOperationException("ERROR: getShade() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @NotNull
    public LevelLightEngine getLightEngine() {
        throw new UnsupportedOperationException("ERROR: getLightEngine() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @Nullable
    public BlockEntity getBlockEntity(@NotNull BlockPos pos) {
        throw new UnsupportedOperationException("ERROR: getBlockEntity() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @NotNull
    public BlockState getBlockState(@NotNull BlockPos pos) {
        throw new UnsupportedOperationException("ERROR: getBlockState() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockPos pos) {
        throw new UnsupportedOperationException("ERROR: getFluidState() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    public int getHeight() {
        throw new UnsupportedOperationException("ERROR: getHeight() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    public int getMinY() {
        throw new UnsupportedOperationException("ERROR: getMinY() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }
}

