/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5537;
import yalter.mousetweaks.Config;
import yalter.mousetweaks.IGuiScreenHandler;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.MouseButton;
import yalter.mousetweaks.WheelSearchOrder;
import yalter.mousetweaks.api.IMTModGuiContainer3Ex;
import yalter.mousetweaks.handlers.GuiContainerCreativeHandler;
import yalter.mousetweaks.handlers.GuiContainerHandler;
import yalter.mousetweaks.handlers.IMTModGuiContainer3ExHandler;

public class Main {
    public static Config config;
    private static class_310 mc;
    private static class_437 openScreen;
    private static IGuiScreenHandler handler;
    private static boolean disableWheelForThisContainer;
    private static class_1735 oldSelectedSlot;
    private static double accumulatedScrollDelta;
    private static boolean canDoLMBDrag;
    private static boolean canDoRMBDrag;
    private static boolean rmbTweakLeftOriginalSlot;
    private static boolean initialized;

    public static void initialize() {
        Logger.Log("Main.initialize()");
        if (initialized) {
            return;
        }
        mc = class_310.method_1551();
        config = new Config(Main.mc.field_1697.getAbsolutePath() + File.separator + "config" + File.separator + "MouseTweaks.cfg");
        config.read();
        Logger.Log("Initialized.");
        initialized = true;
    }

    private static void updateScreen(class_437 newScreen) {
        if (newScreen == openScreen) {
            return;
        }
        openScreen = newScreen;
        handler = null;
        oldSelectedSlot = null;
        accumulatedScrollDelta = 0.0;
        canDoLMBDrag = false;
        canDoRMBDrag = false;
        rmbTweakLeftOriginalSlot = false;
        if (openScreen != null) {
            Logger.DebugLog("You have just opened a " + openScreen.getClass().getName() + ".");
            config.read();
            handler = Main.findHandler(openScreen);
            if (handler == null) {
                Logger.DebugLog("No valid handler found; Mouse Tweaks is disabled.");
            } else {
                boolean disableForThisContainer = handler.isMouseTweaksDisabled();
                disableWheelForThisContainer = handler.isWheelTweakDisabled();
                Logger.DebugLog("Handler: " + handler.getClass().getSimpleName() + "; Mouse Tweaks is " + (disableForThisContainer ? "disabled" : "enabled") + "; wheel tweak is " + (disableWheelForThisContainer ? "disabled" : "enabled") + ".");
                if (disableForThisContainer) {
                    handler = null;
                }
            }
        }
    }

    public static boolean onMouseClicked(class_437 screen, double x, double y, MouseButton button) {
        Main.updateScreen(screen);
        if (handler == null) {
            return false;
        }
        oldSelectedSlot = handler.getSlotUnderMouse(x, y);
        class_1799 stackOnMouse = Main.mc.field_1724.field_7512.method_34255();
        if (button == MouseButton.LEFT) {
            if (stackOnMouse.method_7960()) {
                canDoLMBDrag = true;
            }
        } else if (button == MouseButton.RIGHT) {
            if (stackOnMouse.method_7960()) {
                return false;
            }
            if (!Main.config.rmbTweak) {
                return false;
            }
            canDoRMBDrag = true;
            rmbTweakLeftOriginalSlot = false;
        }
        return false;
    }

    private static void rmbTweakMaybeClickSlot(class_1735 slot, class_1799 stackOnMouse) {
        if (slot == null) {
            return;
        }
        if (stackOnMouse.method_7960()) {
            return;
        }
        if (handler.isIgnored(slot)) {
            return;
        }
        if (handler.isCraftingOutput(slot)) {
            return;
        }
        if (!(stackOnMouse.method_7909() instanceof class_5537)) {
            class_1799 selectedSlotStack = slot.method_7677();
            if (!Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
                return;
            }
            if (selectedSlotStack.method_7947() == slot.method_7676(selectedSlotStack)) {
                return;
            }
        }
        handler.clickSlot(slot, MouseButton.RIGHT, false);
    }

    public static boolean onMouseReleased(class_437 screen, double x, double y, MouseButton button) {
        Main.updateScreen(screen);
        if (handler == null) {
            return false;
        }
        if (button == MouseButton.LEFT) {
            canDoLMBDrag = false;
        } else if (button == MouseButton.RIGHT) {
            canDoRMBDrag = false;
        }
        return false;
    }

    public static boolean onMouseDrag(class_437 screen, double x, double y, MouseButton button) {
        Main.updateScreen(screen);
        if (handler == null) {
            return false;
        }
        class_1735 selectedSlot = handler.getSlotUnderMouse(x, y);
        if (selectedSlot == oldSelectedSlot) {
            return false;
        }
        class_1799 stackOnMouse = Main.mc.field_1724.field_7512.method_34255();
        if (canDoRMBDrag && button == MouseButton.RIGHT && !rmbTweakLeftOriginalSlot) {
            rmbTweakLeftOriginalSlot = true;
            handler.disableRMBDraggingFunctionality();
            Main.rmbTweakMaybeClickSlot(oldSelectedSlot, stackOnMouse);
        }
        oldSelectedSlot = selectedSlot;
        if (selectedSlot == null) {
            return false;
        }
        if (handler.isIgnored(selectedSlot)) {
            return false;
        }
        if (button == MouseButton.LEFT) {
            boolean shiftIsDown;
            if (!canDoLMBDrag) {
                return false;
            }
            class_1799 selectedSlotStack = selectedSlot.method_7677();
            if (selectedSlotStack.method_7960()) {
                return false;
            }
            boolean bl = shiftIsDown = class_3675.method_15987((long)mc.method_22683().method_4490(), (int)340) || class_3675.method_15987((long)mc.method_22683().method_4490(), (int)344);
            if (stackOnMouse.method_7960()) {
                if (!Main.config.lmbTweakWithoutItem || !shiftIsDown) {
                    return false;
                }
                handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
            } else {
                if (!Main.config.lmbTweakWithItem) {
                    return false;
                }
                if (!Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
                    return false;
                }
                if (shiftIsDown) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
                } else {
                    if (stackOnMouse.method_7947() + selectedSlotStack.method_7947() > stackOnMouse.method_7914()) {
                        return false;
                    }
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                    if (!handler.isCraftingOutput(selectedSlot)) {
                        handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                    }
                }
            }
        } else if (button == MouseButton.RIGHT) {
            if (!canDoRMBDrag) {
                return false;
            }
            Main.rmbTweakMaybeClickSlot(selectedSlot, stackOnMouse);
        }
        return false;
    }

    public static boolean onMouseScrolled(class_437 screen, double x, double y, double scrollDelta) {
        class_1735 targetSlot;
        boolean pushItems;
        Main.updateScreen(screen);
        if (handler == null || disableWheelForThisContainer || !Main.config.wheelTweak) {
            return false;
        }
        class_1735 selectedSlot = handler.getSlotUnderMouse(x, y);
        if (selectedSlot == null || handler.isIgnored(selectedSlot)) {
            return false;
        }
        class_1799 selectedSlotStack = selectedSlot.method_7677();
        if (selectedSlotStack.method_7909() instanceof class_5537) {
            return false;
        }
        double scaledDelta = Main.config.scrollItemScaling.scale(scrollDelta);
        if (accumulatedScrollDelta != 0.0 && Math.signum(scaledDelta) != Math.signum(accumulatedScrollDelta)) {
            accumulatedScrollDelta = 0.0;
        }
        int delta = (int)(accumulatedScrollDelta += scaledDelta);
        accumulatedScrollDelta -= (double)delta;
        if (delta == 0) {
            return true;
        }
        List<class_1735> slots = handler.getSlots();
        int numItemsToMove = Math.abs(delta);
        boolean bl = pushItems = delta < 0;
        if (Main.config.wheelScrollDirection.isPositionAware() && Main.otherInventoryIsAbove(selectedSlot, slots)) {
            boolean bl2 = pushItems = !pushItems;
        }
        if (Main.config.wheelScrollDirection.isInverted()) {
            boolean bl3 = pushItems = !pushItems;
        }
        if (selectedSlotStack.method_7960()) {
            return true;
        }
        class_1799 stackOnMouse = Main.mc.field_1724.field_7512.method_34255();
        if (handler.isCraftingOutput(selectedSlot)) {
            if (!Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
                return true;
            }
            if (stackOnMouse.method_7960()) {
                List<class_1735> targetSlots;
                if (!pushItems) {
                    return true;
                }
                while (numItemsToMove-- > 0 && (targetSlots = Main.findPushSlots(slots, selectedSlot, selectedSlotStack.method_7947(), true)) != null) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                    for (int i = 0; i < targetSlots.size(); ++i) {
                        class_1735 slot = targetSlots.get(i);
                        if (i == targetSlots.size() - 1) {
                            handler.clickSlot(slot, MouseButton.LEFT, false);
                            continue;
                        }
                        int clickTimes = slot.method_7676(slot.method_7677()) - slot.method_7677().method_7947();
                        while (clickTimes-- > 0) {
                            handler.clickSlot(slot, MouseButton.RIGHT, false);
                        }
                    }
                }
            } else {
                while (numItemsToMove-- > 0) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                }
            }
            return true;
        }
        if (!stackOnMouse.method_7960() && Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
            return true;
        }
        if (pushItems) {
            if (!stackOnMouse.method_7960() && !selectedSlot.method_7680(stackOnMouse)) {
                return true;
            }
            numItemsToMove = Math.min(numItemsToMove, selectedSlotStack.method_7947());
            List<class_1735> targetSlots = Main.findPushSlots(slots, selectedSlot, numItemsToMove, false);
            assert (targetSlots != null);
            if (targetSlots.isEmpty()) {
                return true;
            }
            handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
            for (class_1735 slot : targetSlots) {
                int clickTimes = slot.method_7676(slot.method_7677()) - slot.method_7677().method_7947();
                clickTimes = Math.min(clickTimes, numItemsToMove);
                numItemsToMove -= clickTimes;
                while (clickTimes-- > 0) {
                    handler.clickSlot(slot, MouseButton.RIGHT, false);
                }
            }
            handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
            return true;
        }
        int maxItemsToMove = selectedSlot.method_7676(selectedSlotStack) - selectedSlotStack.method_7947();
        numItemsToMove = Math.min(numItemsToMove, maxItemsToMove);
        while (numItemsToMove > 0 && (targetSlot = Main.findPullSlot(slots, selectedSlot)) != null) {
            int numItemsInTargetSlot = targetSlot.method_7677().method_7947();
            if (handler.isCraftingOutput(targetSlot)) {
                if (maxItemsToMove < numItemsInTargetSlot) break;
                numItemsToMove = Math.min(numItemsToMove - 1, maxItemsToMove -= numItemsInTargetSlot);
                if (!stackOnMouse.method_7960() && !selectedSlot.method_7680(stackOnMouse)) break;
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                handler.clickSlot(targetSlot, MouseButton.LEFT, false);
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                continue;
            }
            int numItemsToMoveFromTargetSlot = Math.min(numItemsToMove, numItemsInTargetSlot);
            maxItemsToMove -= numItemsToMoveFromTargetSlot;
            numItemsToMove -= numItemsToMoveFromTargetSlot;
            if (!stackOnMouse.method_7960() && !targetSlot.method_7680(stackOnMouse)) break;
            handler.clickSlot(targetSlot, MouseButton.LEFT, false);
            if (numItemsToMoveFromTargetSlot == numItemsInTargetSlot) {
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
            } else {
                for (int i = 0; i < numItemsToMoveFromTargetSlot; ++i) {
                    handler.clickSlot(selectedSlot, MouseButton.RIGHT, false);
                }
            }
            handler.clickSlot(targetSlot, MouseButton.LEFT, false);
        }
        return true;
    }

    private static boolean otherInventoryIsAbove(class_1735 selectedSlot, List<class_1735> slots) {
        boolean selectedIsInPlayerInventory = selectedSlot.field_7871 == Main.mc.field_1724.method_31548();
        int otherInventorySlotsBelow = 0;
        int otherInventorySlotsAbove = 0;
        for (class_1735 slot : slots) {
            if (slot.field_7871 == Main.mc.field_1724.method_31548() == selectedIsInPlayerInventory) continue;
            if (slot.field_7872 < selectedSlot.field_7872) {
                ++otherInventorySlotsAbove;
                continue;
            }
            ++otherInventorySlotsBelow;
        }
        return otherInventorySlotsAbove > otherInventorySlotsBelow;
    }

    private static IGuiScreenHandler findHandler(class_437 currentScreen) {
        if (currentScreen instanceof IMTModGuiContainer3Ex) {
            return new IMTModGuiContainer3ExHandler((IMTModGuiContainer3Ex)currentScreen);
        }
        if (currentScreen instanceof class_481) {
            return new GuiContainerCreativeHandler((class_481)currentScreen);
        }
        if (currentScreen instanceof class_465) {
            return new GuiContainerHandler((class_465)currentScreen);
        }
        return null;
    }

    private static boolean areStacksCompatible(class_1799 a, class_1799 b) {
        return a.method_7960() || b.method_7960() || class_1799.method_7984((class_1799)a, (class_1799)b) && class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    private static class_1735 findPullSlot(List<class_1735> slots, class_1735 selectedSlot) {
        int direction;
        int endIndex;
        if (Main.config.wheelSearchOrder == WheelSearchOrder.FIRST_TO_LAST) {
            startIndex = 0;
            endIndex = slots.size();
            direction = 1;
        } else {
            startIndex = slots.size() - 1;
            endIndex = -1;
            direction = -1;
        }
        class_1799 selectedSlotStack = selectedSlot.method_7677();
        boolean findInPlayerInventory = selectedSlot.field_7871 != Main.mc.field_1724.method_31548();
        for (int i = startIndex; i != endIndex; i += direction) {
            class_1799 stack;
            boolean slotInPlayerInventory;
            class_1735 slot = slots.get(i);
            if (handler.isIgnored(slot)) continue;
            boolean bl = slotInPlayerInventory = slot.field_7871 == Main.mc.field_1724.method_31548();
            if (findInPlayerInventory != slotInPlayerInventory || (stack = slot.method_7677()).method_7960() || !Main.areStacksCompatible(selectedSlotStack, stack)) continue;
            return slot;
        }
        return null;
    }

    private static List<class_1735> findPushSlots(List<class_1735> slots, class_1735 selectedSlot, int itemCount, boolean mustDistributeAll) {
        class_1735 slot;
        int i;
        class_1799 selectedSlotStack = selectedSlot.method_7677();
        boolean findInPlayerInventory = selectedSlot.field_7871 != Main.mc.field_1724.method_31548();
        ArrayList<class_1735> rv = new ArrayList<class_1735>();
        ArrayList<class_1735> goodEmptySlots = new ArrayList<class_1735>();
        for (i = 0; i != slots.size() && itemCount > 0; ++i) {
            boolean slotInPlayerInventory;
            slot = slots.get(i);
            if (handler.isIgnored(slot)) continue;
            boolean bl = slotInPlayerInventory = slot.field_7871 == Main.mc.field_1724.method_31548();
            if (findInPlayerInventory != slotInPlayerInventory || handler.isCraftingOutput(slot)) continue;
            class_1799 stack = slot.method_7677();
            if (stack.method_7960()) {
                if (!slot.method_7680(selectedSlotStack)) continue;
                goodEmptySlots.add(slot);
                continue;
            }
            if (!Main.areStacksCompatible(selectedSlotStack, stack) || stack.method_7947() >= slot.method_7676(stack)) continue;
            rv.add(slot);
            itemCount -= Math.min(itemCount, slot.method_7676(stack) - stack.method_7947());
        }
        for (i = 0; i != goodEmptySlots.size() && itemCount > 0; itemCount -= Math.min(itemCount, slot.method_7675()), ++i) {
            slot = (class_1735)goodEmptySlots.get(i);
            rv.add(slot);
        }
        if (mustDistributeAll && itemCount > 0) {
            return null;
        }
        return rv;
    }

    static {
        openScreen = null;
        handler = null;
        disableWheelForThisContainer = false;
        oldSelectedSlot = null;
        accumulatedScrollDelta = 0.0;
        canDoLMBDrag = false;
        canDoRMBDrag = false;
        rmbTweakLeftOriginalSlot = false;
        initialized = false;
    }
}

